/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.phase;

import com.google.common.collect.Lists;
import java.util.List;
import lovexyn0827.mess.util.phase.TickingPhase;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

public enum ClientTickingPhase implements TickingPhase
{
    CLIENT_TICK_START,
    CLIENT_TICK_END;

    private final List<TickingPhase.Event> events = Lists.newArrayList();

    @Override
    public void begin(@Nullable class_1937 world) {
        this.triggerEvents(world);
    }

    protected synchronized void triggerEvents(@Nullable class_1937 world) {
        this.events.forEach(e -> e.trigger(this, world));
    }

    @Override
    public synchronized void addEvent(TickingPhase.Event event) {
        this.events.add(event);
    }

    @Override
    public synchronized void removeEvent(TickingPhase.Event event) {
        this.events.remove(event);
    }

    @Override
    public boolean isNotInAnyWorld() {
        return true;
    }

    public static void addEventToAll(TickingPhase.Event event) {
        for (ClientTickingPhase phase : ClientTickingPhase.values()) {
            phase.addEvent(event);
        }
    }

    public static void removeAllEvents() {
        for (ClientTickingPhase phase : ClientTickingPhase.values()) {
            phase.events.clear();
        }
    }

    public static void removeEventFromAll(TickingPhase.Event event) {
        for (ClientTickingPhase phase : ClientTickingPhase.values()) {
            phase.removeEvent(event);
        }
    }
}

