/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.deobfuscating;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import lovexyn0827.mess.util.deobfuscating.MethodInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class TinyMapping
implements Mapping {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BiMap<String, String> classes = HashBiMap.create();
    private final Map<String, BiMap<String, String>> fieldsByClass;
    private final Map<String, String> fields = new HashMap<String, String>();
    private final Map<String, String> methods;
    private final Map<String, Set<MethodInfo>> methodsByClass;

    public TinyMapping(File mappingFile) throws FileNotFoundException {
        this(new BufferedReader(new FileReader(mappingFile)));
    }

    public TinyMapping(BufferedReader r) {
        this.fieldsByClass = new HashMap<String, BiMap<String, String>>();
        this.methods = new HashMap<String, String>();
        this.methodsByClass = new HashMap<String, Set<MethodInfo>>();
        try (BufferedReader br = r;){
            TinyMappingParser.visit(br, new Reader());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String namedClass(String srg) {
        return (String)this.classes.getOrDefault((Object)srg, (Object)srg);
    }

    @Override
    @Nullable
    public String srgClass(String named) {
        return (String)this.classes.inverse().getOrDefault((Object)named, (Object)named);
    }

    @Override
    public String namedField(String srg) {
        return this.fields.getOrDefault(srg, srg);
    }

    @Override
    @Nullable
    public String srgField(String clazz, String named) {
        BiMap<String, String> classMap = this.fieldsByClass.get(clazz);
        if (classMap == null) {
            return null;
        }
        return (String)classMap.inverse().getOrDefault((Object)named, (Object)named);
    }

    @Override
    public String namedMethod(String srg, String desc) {
        return this.methods.getOrDefault(srg, srg);
    }

    @Override
    @Nullable
    public String srgMethod(String clazz, String named, String desc) {
        Set<MethodInfo> classMap = this.methodsByClass.get(clazz);
        if (classMap != null) {
            return classMap.stream().filter(m -> m.name.equals(named) && m.descriptor.equals(desc)).map(m -> m.srgName).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public boolean isClassMapped(Class<?> clazz) {
        return this.classes.containsKey((Object)clazz.getCanonicalName());
    }

    private class Reader {
        private int namedIndex;
        private int srgIndex;
        private String currentClassSrg;

        private Reader() {
        }

        public void start(MessTinyMetadata metadata) {
            this.namedIndex = metadata.index("named");
            this.srgIndex = metadata.index("intermediary");
        }

        public void pushClass(TinyMappingParser.MessMappingGetter name) {
            String[] names = name.getAllNames();
            String srg = names[this.srgIndex].replace('/', '.');
            String named = names[this.namedIndex].replace('/', '.');
            TinyMapping.this.classes.put((Object)srg, (Object)named);
            this.currentClassSrg = srg;
            TinyMapping.this.fieldsByClass.put(srg, HashBiMap.create());
            TinyMapping.this.methodsByClass.put(srg, new HashSet());
        }

        public void pushField(TinyMappingParser.MessMappingGetter name, String descriptor) {
            String[] names = name.getAllNames();
            BiMap map = (BiMap)TinyMapping.this.fieldsByClass.get(this.currentClassSrg);
            TinyMapping.this.fields.put(names[this.srgIndex], names[this.namedIndex]);
            map.put((Object)names[this.srgIndex], (Object)names[this.namedIndex]);
        }

        public void pushMethod(TinyMappingParser.MessMappingGetter name, String descriptor) {
            String[] names = name.getAllNames();
            ((Set)TinyMapping.this.methodsByClass.get(this.currentClassSrg)).add(new MethodInfo(names[this.srgIndex], names[this.namedIndex], descriptor));
            TinyMapping.this.methods.put(names[this.srgIndex], names[this.namedIndex]);
        }
    }

    private static final class TinyMappingParser {
        private static final String[] NAME_CACHE = new String[16];

        private TinyMappingParser() {
        }

        public static void visit(BufferedReader br, Reader reader) throws IOException {
            String line;
            String metaLine = br.readLine();
            String[] metaSplited = metaLine.split("\t");
            if (metaSplited.length < 5 || !metaSplited[0].equals("tiny")) {
                LOGGER.warn("Trying to read non-tiny mapping, which is not supported!");
                throw new RuntimeException("Trying to read non-tiny mapping, which is not supported!");
            }
            if (Integer.parseInt(metaSplited[1]) != 2) {
                LOGGER.warn("Unsupported maapping version: {}", (Object)Integer.parseInt(metaSplited[2]));
                throw new RuntimeException(String.format("Unsupported maapping version: %s", metaSplited[2]));
            }
            ArrayList<String> namespaces = new ArrayList<String>();
            for (int i = 3; i < metaSplited.length; ++i) {
                namespaces.add(metaSplited[i]);
            }
            reader.start(new MessTinyMetadata(namespaces));
            while ((line = br.readLine()) != null) {
                String pure = line.trim();
                switch (pure.charAt(0)) {
                    case 'c': {
                        int i;
                        if (line.charAt(0) == '\t') break;
                        String[] parts = pure.split("\t");
                        for (i = 1; i < parts.length; ++i) {
                            TinyMappingParser.NAME_CACHE[i - 1] = parts[i];
                        }
                        reader.pushClass(MessMappingGetter.INSTANCE);
                        break;
                    }
                    case 'f': {
                        int i;
                        String[] parts = pure.split("\t");
                        for (i = 2; i < parts.length; ++i) {
                            TinyMappingParser.NAME_CACHE[i - 2] = parts[i];
                        }
                        reader.pushField(MessMappingGetter.INSTANCE, parts[1]);
                        break;
                    }
                    case 'm': {
                        int i;
                        String[] parts = pure.split("\t");
                        for (i = 2; i < parts.length; ++i) {
                            TinyMappingParser.NAME_CACHE[i - 2] = parts[i];
                        }
                        reader.pushMethod(MessMappingGetter.INSTANCE, parts[1]);
                    }
                }
            }
        }

        private static final class MessMappingGetter {
            public static final MessMappingGetter INSTANCE = new MessMappingGetter();

            private MessMappingGetter() {
            }

            public String[] getAllNames() {
                return NAME_CACHE;
            }
        }
    }

    private static final class MessTinyMetadata {
        private final List<String> namespaces;

        private MessTinyMetadata(List<String> namespaces) {
            this.namespaces = namespaces;
        }

        public int index(String string) {
            return this.namespaces.indexOf(string);
        }
    }
}

