/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.deobfuscating;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilderFactory;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.util.deobfuscating.DummyMapping;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import lovexyn0827.mess.util.deobfuscating.TinyMapping;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_156;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class MappingProvider {
    public static final Logger LOGGER = MessMod.LOGGER;
    private final Source source = Source.YARN;

    @NotNull
    public Mapping tryLoadMapping() {
        DummyMapping dummy = new DummyMapping();
        try {
            Class.forName("net.minecraft.entity.Entity");
            LOGGER.info("The Minecraft has probably been deobfuscated, the mapping won't be loaded");
            return new DummyMapping();
        }
        catch (ClassNotFoundException e) {
            File mappingFolder = new File("mappings");
            if (!mappingFolder.exists()) {
                mappingFolder.mkdir();
            }
            File mappingFile = new File(FabricLoader.getInstance().getGameDir().toString() + "/mappings/" + class_155.method_16673().getName() + ".tiny");
            try {
                if (mappingFile.exists()) {
                    LOGGER.info("Found corresponding Tiny mapping, trying to load it...");
                    return new TinyMapping(mappingFile);
                }
                if (this.source == Source.YARN && MappingProvider.tryDownloadYarnMapping(mappingFile.toPath())) {
                    LOGGER.info("Downloaded the mapping successfully, loading it...");
                    return new TinyMapping(mappingFile);
                }
                if (this.source == Source.YARN && FabricLoader.getInstance().isModLoaded("carpet-tis-addition")) {
                    return MappingProvider.tryLoadMappingFromTisAddition().orElse(dummy);
                }
            }
            catch (Exception e1) {
                LOGGER.warn("Failed to load mapping for MessMod!");
                e1.printStackTrace();
            }
            LOGGER.error("The mapping couldn't be downloaded, it is recommended to try to download the mapping manually. Deobfuscating will be disabled in this running.");
            LOGGER.error("The mapping should be downloaded to " + mappingFile.getAbsolutePath());
            return dummy;
        }
    }

    private static Optional<Mapping> tryLoadMappingFromTisAddition() throws IOException {
        LOGGER.info("Trying to load mapping bundled in Carpet TIS Addition...");
        Path path = Files.walk(((ModContainer)FabricLoader.getInstance().getModContainer("carpet-tis-addition").get()).getPath("assets/carpettisaddition"), new FileVisitOption[0]).filter(f -> f.getFileName().toString().endsWith(".tiny")).findFirst().orElse(null);
        if (path != null) {
            LOGGER.info("The mapping was found, loading it...");
            return Optional.of(new TinyMapping(Files.newBufferedReader(path)));
        }
        return Optional.empty();
    }

    private static boolean tryDownloadYarnMapping(Path to) {
        try {
            String mcVer = class_155.method_16673().getName();
            LOGGER.info("Trying to download the lastest yarn mapping from Maven...");
            long start = class_156.method_658();
            URL listUrl = new URL("https://maven.fabricmc.net/net/fabricmc/yarn/maven-metadata.xml");
            TreeSet<String> foundMappings = new TreeSet<String>();
            try (InputStream is = listUrl.openStream();){
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(is);
                NodeList versions = doc.getElementsByTagName("version");
                for (int i = 0; i < versions.getLength(); ++i) {
                    String ver = versions.item(i).getTextContent();
                    if (!ver.replaceAll("\\+.+", "").equals(mcVer)) continue;
                    foundMappings.add(ver.replace("+", "%2B"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.warn("Failed to parse the mapping version list!");
                return false;
            }
            if (foundMappings.isEmpty()) {
                LOGGER.warn("No corresponding mapping was found.");
                return false;
            }
            String latest = (String)foundMappings.last();
            URL url = new URL("https://maven.fabricmc.net/net/fabricmc/yarn/" + latest + "/yarn-" + latest + "-v2.jar");
            Path temp = Files.createTempFile("yarn-" + mcVer, ".jar", new FileAttribute[0]);
            InputStream is = url.openStream();
            Files.copy(is, temp, StandardCopyOption.REPLACE_EXISTING);
            is.close();
            try (ZipFile zf = new ZipFile(temp.toFile());){
                Files.copy(zf.getInputStream(zf.getEntry("mappings/mappings.tiny")), to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to download the mapping: " + e);
                e.printStackTrace();
                return false;
            }
            long end = class_156.method_658();
            LOGGER.info("Downloaded the mapping in roughly " + (end - start) + "ms.");
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to download the mapping: " + e);
            e.printStackTrace();
            return false;
        }
    }

    public static enum Source {
        YARN,
        OFFICAL,
        MCP;

    }
}

