/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.deobfuscating;

import java.util.Arrays;
import lovexyn0827.mess.util.deobfuscating.DummyMapping;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public interface Mapping {
    @NotNull
    public String namedClass(String var1);

    @NotNull
    public String srgClass(String var1);

    @NotNull
    public String namedField(String var1);

    @NotNull
    public String srgField(String var1, String var2);

    @NotNull
    public String namedMethod(String var1, String var2);

    @NotNull
    public String srgMethod(String var1, String var2, String var3);

    public boolean isClassMapped(Class<?> var1);

    @NotNull
    default public String srgFieldRecursively(Class<?> targetClass, String fieldName) {
        if (this.isDummy()) {
            return fieldName;
        }
        while (targetClass != null) {
            String srg = this.srgField(targetClass.getName(), fieldName);
            if (srg != null) {
                return srg;
            }
            for (Class<?> in : targetClass.getInterfaces()) {
                srg = this.srgFieldRecursively(in, fieldName);
                if (srg.equals(fieldName)) continue;
                return srg;
            }
            targetClass = targetClass.getSuperclass();
        }
        return fieldName;
    }

    @NotNull
    default public String srgMethodRecursively(Class<?> targetClass, String name, String desc) {
        if (this.isDummy() || !this.isClassMapped(targetClass)) {
            return name;
        }
        while (targetClass != null) {
            String srg = this.srgMethod(targetClass.getName(), name, desc);
            if (srg != null) {
                return srg;
            }
            for (Class<?> in : targetClass.getInterfaces()) {
                srg = this.srgMethodRecursively(in, name, desc);
                if (srg.equals(name)) continue;
                return srg;
            }
            targetClass = targetClass.getSuperclass();
        }
        return name;
    }

    default public boolean isDummy() {
        return this instanceof DummyMapping;
    }

    @NotNull
    default public String simpleNamedClass(String srg) {
        String named = this.namedClass(srg);
        return named.substring(named.lastIndexOf(46) + 1, named.length());
    }

    default public String srgDescriptor(String namedDesc) {
        if (namedDesc.isEmpty()) {
            throw new IllegalArgumentException("Descriptors mustn't be empty!");
        }
        switch (namedDesc.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return namedDesc;
            }
            case '[': {
                return '[' + this.srgDescriptor(namedDesc.substring(1));
            }
            case 'L': {
                return 'L' + this.srgClass(namedDesc.substring(1, namedDesc.length() - 1).replace('/', '.')).replace('.', '/') + ';';
            }
        }
        throw new IllegalArgumentException("Malformed descriptor: " + namedDesc);
    }

    default public String srgMethodDescriptor(String namedDesc) {
        Type descType = Type.getMethodType((String)namedDesc);
        Type[] srgArgTypes = (Type[])Arrays.stream(descType.getArgumentTypes()).map(Type::getDescriptor).map(this::srgDescriptor).map(Type::getType).toArray(Type[]::new);
        return Type.getMethodDescriptor((Type)Type.getType((String)this.srgDescriptor(descType.getReturnType().getDescriptor())), (Type[])srgArgTypes);
    }
}

