/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.CompilationException;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.NodeCompiler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class SizeNode
extends Node {
    @Override
    boolean canFollow(Node n) {
        Type t = n.outputType;
        return t instanceof Class && (((Class)t).isArray() || Collection.class.isAssignableFrom((Class)t));
    }

    @Override
    Object access(Object previous) throws AccessingFailureException {
        if (previous.getClass().isArray()) {
            return Array.getLength(previous);
        }
        if (previous instanceof Collection) {
            Collection c = (Collection)previous;
            return c.size();
        }
        if (previous instanceof CharSequence) {
            return ((CharSequence)previous).length();
        }
        if (previous instanceof Map) {
            Map m = (Map)previous;
            return m.size();
        }
        throw AccessingFailureException.createWithArgs(FailureCause.INV_LAST, this, null, this);
    }

    @Override
    protected Type resolveOutputType(Type lastOutType) {
        return Integer.TYPE;
    }

    @Override
    NodeCompiler getCompiler() {
        return ctx -> {
            InsnList insns = new InsnList();
            Class<?> clazz = ctx.getLastOutputClass();
            if (clazz.isArray()) {
                insns.add((AbstractInsnNode)new InsnNode(190));
            } else if (Collection.class.isAssignableFrom(clazz)) {
                insns.add((AbstractInsnNode)new TypeInsnNode(192, "java/util/Collection"));
                insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Collection", "size", "()I"));
            } else if (CharSequence.class.isAssignableFrom(clazz)) {
                insns.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/CharSequence"));
                insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/lang/CharSequence", "length", "()I"));
            } else if (Map.class.isAssignableFrom(clazz)) {
                insns.add((AbstractInsnNode)new TypeInsnNode(192, "java/util/Map"));
                insns.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Map", "size", "()I"));
            } else {
                throw new CompilationException(FailureCause.INV_LAST, this);
            }
            ctx.endNode(Integer.TYPE);
            return insns;
        };
    }
}

