/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.util.ArgumentListTokenizer;
import lovexyn0827.mess.util.MethodDescriptor;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.BytecodeHelper;
import lovexyn0827.mess.util.access.CompilationContext;
import lovexyn0827.mess.util.access.CompilationException;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.Literal;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.NodeCompiler;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;

public class MapperNode
extends Node {
    static final Pattern PATTERN = Pattern.compile("^(?<class>([a-zA-Z0-9_$]+/)*([a-zA-Z0-9_$]+))::(?<name>[$_a-zA-Z0-9]+)(?:\\<(?<types>[^>]*)\\>)?(\\((?<args>.*)\\))?$");
    private final Method method;
    @NotNull
    private final Literal<?>[] arguments;
    private final Mode mode;

    public MapperNode(String toParse) throws CommandSyntaxException {
        Triple<Method, Literal<?>[], Mode> result = MapperNode.parse(toParse);
        this.method = (Method)result.getLeft();
        this.arguments = (Literal[])result.getMiddle();
        this.mode = (Mode)((Object)result.getRight());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Triple<Method, Literal<?>[], Mode> parse(String toParse) throws CommandSyntaxException {
        Mode mode;
        Literal<?>[] args;
        Matcher matcher = PATTERN.matcher(toParse);
        if (!matcher.matches()) throw new TranslatableException("exp.mapper.format");
        String name = matcher.group("name");
        String className = matcher.group("class").replace('/', '.');
        if (name == null && className == null) {
            throw new TranslatableException("exp.mapper.format");
        }
        String typesStr = matcher.group("types");
        String argsStr = matcher.group("args");
        Optional<Method> mayMethod = MapperNode.resolveMethod(className, name, typesStr);
        if (!mayMethod.isPresent()) {
            String mS = name + (typesStr == null ? "" : '<' + typesStr + ">");
            throw new TranslatableException("exp.nomethod", mS, className);
        }
        Method method = mayMethod.get();
        if (typesStr == null) {
            boolean hasArgs;
            boolean bl = hasArgs = argsStr == null || argsStr.isEmpty();
            if (!hasArgs) {
                throw new TranslatableException("exp.mapper.unsupportedargs");
            }
            args = new Literal[]{null};
            mode = Mode.SIMPLE;
            return Triple.of((Object)method, args, (Object)((Object)mode));
        } else {
            if (argsStr == null) throw new TranslatableException("exp.mapper.format");
            args = MapperNode.parseArgs(method, argsStr);
            mode = Mode.NORMAL;
        }
        return Triple.of((Object)method, args, (Object)((Object)mode));
    }

    public static Literal<?>[] parseArgs(Method method, String argsStr) throws CommandSyntaxException {
        if (!argsStr.isEmpty()) {
            String[] argLS = new ArgumentListTokenizer(argsStr).toArray();
            int givenArgCount = argLS.length;
            if (givenArgCount != method.getParameterCount()) {
                throw new TranslatableException("exp.argcount", method.getParameterCount(), givenArgCount);
            }
            Literal[] argL = new Literal[givenArgCount];
            for (int i = 0; i < givenArgCount; ++i) {
                String str = argLS[i];
                if ("_".equals(str)) {
                    argL[i] = null;
                    continue;
                }
                if (str.isEmpty()) {
                    throw new TranslatableException("exp.emptyarg");
                }
                argL[i] = Literal.parse(str);
            }
            return argL;
        }
        return new Literal[0];
    }

    private static Optional<Method> resolveMethod(String className, String name, String typesStr) {
        Class<?> clazz;
        Mapping map = MessMod.INSTANCE.getMapping();
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            TranslatableException e1 = new TranslatableException("exp.noclass", className);
            e1.initCause(e);
            throw e1;
        }
        if (typesStr == null) {
            return Reflection.listMethods(clazz).stream().filter(m -> {
                String descriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)m);
                Class<?> declaringClass = m.getDeclaringClass();
                String srg = map.srgMethodRecursively(declaringClass, name, descriptor);
                return m.getName().equals(srg) && m.getParameterCount() == 1 && !m.isSynthetic() && m.getReturnType() != Void.TYPE;
            }).findFirst();
        }
        if (typesStr.matches("[0-9]+")) {
            int argNum = Integer.parseInt(typesStr);
            List targets = Reflection.listMethods(clazz).stream().filter(m -> m.getName().equals(name)).filter(m -> m.getParameterCount() == argNum).map(Reflection::getDeepestOverridenMethod).distinct().collect(Collectors.toList());
            if (targets.size() > 1) {
                throw new TranslatableException("exp.multitarget");
            }
            if (targets.size() == 0) {
                return Optional.empty();
            }
            return Optional.of((Method)targets.get(0));
        }
        MethodDescriptor desc = MethodDescriptor.parse(MessMod.INSTANCE.getMapping().srgMethodDescriptor(typesStr));
        return Optional.ofNullable(Reflection.getMethodFromDesc(clazz, name, desc));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + Objects.hash(new Object[]{this.method, this.mode});
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapperNode other = (MapperNode)obj;
        return Arrays.equals(this.arguments, other.arguments) && Objects.equals(this.method, other.method) && this.mode == other.mode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.method == null ? "???" : this.method.getDeclaringClass().getCanonicalName().replace('.', '/'));
        sb.append("::");
        sb.append(this.method != null ? this.method.getName() : "???");
        if (this.mode != Mode.SIMPLE) {
            sb.append('<');
            sb.append(this.method != null ? org.objectweb.asm.Type.getMethodDescriptor((Method)this.method) : "???");
            sb.append('>');
            sb.append('(');
            if (this.arguments != null) {
                for (Literal<?> l : this.arguments) {
                    sb.append(l.stringRepresentation);
                    sb.append(',');
                }
            } else {
                sb.append("???");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    Object access(Object previous) throws AccessingFailureException {
        try {
            this.method.setAccessible(true);
            if (this.mode == Mode.SIMPLE) {
                try {
                    return this.method.invoke(previous, previous);
                }
                catch (IllegalArgumentException e) {
                    String argList = "[" + previous == null ? "null" : previous.getClass().getCanonicalName() + "]";
                    throw AccessingFailureException.createWithArgs(FailureCause.BAD_ARG, this, e, argList, this.method.toString());
                }
            }
            if (this.mode == Mode.NORMAL) {
                Object[] argObjs = new Object[this.arguments.length];
                Type[] argTypes = this.method.getGenericParameterTypes();
                for (int i = 0; i < this.arguments.length; ++i) {
                    Literal<?> l = this.arguments[i];
                    if (l != null) {
                        try {
                            argObjs[i] = l.get(argTypes[i]);
                            continue;
                        }
                        catch (InvalidLiteralException e) {
                            throw AccessingFailureException.create(e, (Node)this);
                        }
                    }
                    argObjs[i] = previous;
                }
                try {
                    return this.method.invoke(previous, argObjs);
                }
                catch (IllegalArgumentException e) {
                    throw AccessingFailureException.createWithArgs(FailureCause.BAD_ARG, this, e, Arrays.toString(argObjs), this.method.toString());
                }
            }
            throw new IllegalStateException();
        }
        catch (InvocationTargetException e) {
            throw AccessingFailureException.createWithArgs(FailureCause.INVOKE_FAIL, this, e.getCause(), this.method.getName(), e.getCause());
        }
        catch (AccessingFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw AccessingFailureException.createWithArgs(FailureCause.ERROR, this, e, e);
        }
    }

    @Override
    protected Type resolveOutputType(Type lastOutType) throws AccessingFailureException, InvalidLiteralException {
        return this.method.getGenericReturnType();
    }

    @Override
    public boolean allowsPrimitiveTypes() {
        return this.method != null && Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    NodeCompiler getCompiler() {
        return ctx -> {
            InsnList insns = new InsnList();
            if (this.method == null) {
                throw new CompilationException(FailureCause.ERROR, new Object[]{null});
            }
            if (!Modifier.isStatic(this.method.getModifiers())) {
                insns.add((AbstractInsnNode)new InsnNode(89));
            }
            int lastOutIdx = BytecodeHelper.appendLocalVarStorer(ctx, insns, ctx.getLastOutputClass());
            int argsLength = this.arguments.length;
            Class<?>[] argTypes = this.method.getParameterTypes();
            for (int i = 0; i < argsLength; ++i) {
                Literal<?> literal = this.arguments[i];
                if (literal == null) {
                    BytecodeHelper.appendLocalVarLoader(insns, lastOutIdx, ctx.getLastOutputClass());
                    if (argTypes[i].isPrimitive() && !ctx.getLastOutputClass().isPrimitive()) {
                        BytecodeHelper.appendPrimitiveUnwrapper(insns, argTypes[i]);
                    }
                    if (argTypes[i].isPrimitive() || !ctx.getLastOutputClass().isPrimitive()) continue;
                    BytecodeHelper.appendPrimitiveWrapper(insns, argTypes[i]);
                    continue;
                }
                BytecodeHelper.appendConstantLoader(ctx, insns, literal, argTypes[i]);
            }
            BytecodeHelper.appendCaller(insns, this.method, CompilationContext.CallableType.INVOKER);
            ctx.endNode(this.method.getReturnType());
            return insns;
        };
    }

    private static enum Mode {
        SIMPLE,
        NORMAL;

    }
}

