/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.mixins.WorldSavePathMixin;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.access.AccessingPathArgumentType;
import lovexyn0827.mess.util.access.BytecodeHelper;
import lovexyn0827.mess.util.access.CompilationException;
import lovexyn0827.mess.util.access.CompiledPath;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.NodeCompiler;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class CustomNode
extends Node {
    private static final class_5218 SAVED_NODES = WorldSavePathMixin.create("saved_accessing_paths.prop");
    private static final TreeMap<String, String> NODES_BY_NAME = new TreeMap();
    private static final TreeMap<String, Class<?>> COMPILED_NODES_BY_NAME = new TreeMap();
    public static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_]+");
    private final String name;
    private final AccessingPath backend;

    private CustomNode(String name, AccessingPath backend) {
        this.name = name;
        this.backend = backend;
    }

    @Override
    Object access(Object previous) throws AccessingFailureException {
        return this.backend.access(previous, this.inputType);
    }

    @Override
    protected Type resolveOutputType(Type lastOutType) throws AccessingFailureException, InvalidLiteralException {
        return this.backend.getOutputType();
    }

    public static void define(String name, String path, boolean permanent, MinecraftServer server) throws CommandSyntaxException {
        if (NODES_BY_NAME.containsKey(name) || COMPILED_NODES_BY_NAME.containsKey(name)) {
            throw new TranslatableException("cmd.general.dupname");
        }
        AccessingPathArgumentType.accessingPathArg().parse(new StringReader(path));
        NODES_BY_NAME.put(name, path);
        if (permanent) {
            CustomNode.operateSavedNodes(server, p -> p.put(name, path));
        }
    }

    public static void defineCompiled(String name, List<Class<?>> nodeTypes) throws CommandSyntaxException, CompilationException {
        if (!NODES_BY_NAME.containsKey(name)) {
            throw new TranslatableException("%s was not defined", name);
        }
        String pathStr = NODES_BY_NAME.get(name);
        AccessingPath path = AccessingPathArgumentType.accessingPathArg().parse(new StringReader(pathStr));
        COMPILED_NODES_BY_NAME.put(name, path.compile(nodeTypes, name));
    }

    public static void reload(MinecraftServer server) {
        NODES_BY_NAME.clear();
        COMPILED_NODES_BY_NAME.clear();
        CustomNode.operateSavedNodes(server, p -> p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, path) -> NODES_BY_NAME.put((String)name, (String)path))));
    }

    private static void operateSavedNodes(MinecraftServer server, Consumer<Properties> operation) {
        File file = server.method_27050(SAVED_NODES).toFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                TranslatableException e1 = new TranslatableException("cmd.accessingpath.filefail", e.getLocalizedMessage());
                throw e1;
            }
        }
        try (FileReader reader = new FileReader(file);){
            Properties prop = new Properties();
            try {
                prop.load(reader);
            }
            catch (Exception e) {
                MessMod.LOGGER.warn("Couldn't parse saved nodes: {}", (Throwable)e);
                e.printStackTrace();
            }
            operation.accept(prop);
            FileWriter writer = new FileWriter(file);
            prop.store(writer, "Saved Custom Nodes");
        }
        catch (Exception e) {
            TranslatableException e1 = new TranslatableException("cmd.accessingpath.filefail", e.getLocalizedMessage());
            throw e1;
        }
    }

    public static void undefine(String name, MinecraftServer server) {
        if (!NODES_BY_NAME.containsKey(name)) {
            throw new TranslatableException("cmd.accessingpath.undef");
        }
        NODES_BY_NAME.remove(name);
        CustomNode.operateSavedNodes(server, p -> p.remove(name));
    }

    @Nullable
    public static CustomNode byName(String name) throws CommandSyntaxException {
        Class<?> clazz = COMPILED_NODES_BY_NAME.get(name);
        if (clazz != null) {
            try {
                return new CustomNode(name, (CompiledPath)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
        String pathStr = NODES_BY_NAME.get(name);
        if (pathStr == null) {
            return null;
        }
        AccessingPath path = AccessingPathArgumentType.accessingPathArg().parse(new StringReader(pathStr));
        return new CustomNode(name, path);
    }

    public String toString() {
        return this.name;
    }

    public static void listSuggestions(SuggestionsBuilder b) {
        NODES_BY_NAME.keySet().forEach(arg_0 -> ((SuggestionsBuilder)b).suggest(arg_0));
    }

    public static String listDefinitions() {
        StringBuilder sb = new StringBuilder();
        NODES_BY_NAME.forEach((name, path) -> {
            sb.append((String)name);
            sb.append(": ");
            sb.append((String)path);
            sb.append('\n');
        });
        return sb.toString();
    }

    @Override
    NodeCompiler getCompiler() {
        return ctx -> {
            int cid = ctx.allocateSubPath(this.backend);
            InsnList insns = new InsnList();
            BytecodeHelper.appendReferenceConstantGetter(ctx, insns, "SUBPATHS", cid);
            insns.add((AbstractInsnNode)new InsnNode(95));
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)org.objectweb.asm.Type.getType(ctx.getLastOutputClass())));
            insns.add((AbstractInsnNode)new MethodInsnNode(185, org.objectweb.asm.Type.getInternalName(AccessingPath.class), "access", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Ljava/lang/Object;"));
            ctx.endNode((Type)((Object)Object.class));
            return insns;
        };
    }
}

