/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import lovexyn0827.mess.util.access.CompilationContext;
import lovexyn0827.mess.util.access.CompilationException;
import lovexyn0827.mess.util.access.CompiledPath;
import lovexyn0827.mess.util.access.FailureCause;
import lovexyn0827.mess.util.access.InvalidLiteralException;
import lovexyn0827.mess.util.access.Literal;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

final class BytecodeHelper {
    static final ImmutableSet<Class<?>> VALID_TYPES_IN_LDC = ImmutableSet.builder().add(Integer.class).add(Double.class).add(Float.class).add(Long.class).add(String.class).build();
    static final String UNCERTAIN_FIELD_DESCRIPTOR = null;

    private BytecodeHelper() {
    }

    static void appendPrimitiveWrapper(InsnList insns, Class<?> clazz) {
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Integer.class), "valueOf", "(I)Ljava/lang/Integer;"));
        } else if (clazz == Long.TYPE || clazz == Long.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Long.class), "valueOf", "(J)Ljava/lang/Long;"));
        } else if (clazz == Float.TYPE || clazz == Float.class) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Float.class), "valueOf", "(F)Ljava/lang/Float;"));
        } else if (clazz == Double.TYPE || clazz == Double.class) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Double.class), "valueOf", "(D)Ljava/lang/Double;"));
        } else if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Boolean.class), "valueOf", "(Z)Ljava/lang/Boolean;"));
        } else if (clazz == Character.TYPE || clazz == Character.class) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Character.class), "valueOf", "(C)Ljava/lang/Character;"));
        } else if (clazz == Byte.TYPE || clazz == Byte.class) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Byte.class), "valueOf", "(B)Ljava/lang/Byte;"));
        } else if (clazz == Short.TYPE || clazz == Short.class) {
            insns.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(Short.class), "valueOf", "(S)Ljava/lang/Short;"));
        } else {
            throw new IllegalArgumentException("Illegal input class: " + clazz.getCanonicalName());
        }
    }

    static void appendPrimitiveUnwrapper(InsnList insns, Class<?> clazz) {
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Integer.class), "intValue", "()I"));
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Long.class), "longValue", "()J"));
        } else if (clazz == Float.class || clazz == Float.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Float.class), "floatValue", "()F"));
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Double.class), "doubleValue", "()D"));
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Boolean.class), "booleanValue", "()Z"));
        } else if (clazz == Character.class || clazz == Character.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Character.class), "charValue", "()C"));
        } else if (clazz == Byte.class || clazz == Byte.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Byte.class), "byteValue", "()B"));
        } else if (clazz == Short.class || clazz == Short.TYPE) {
            insns.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(Short.class), "shortValue", "()S"));
        } else {
            throw new IllegalArgumentException();
        }
    }

    static void appendIntegerLoader(InsnList insns, int integer) {
        if (integer <= 5) {
            insns.add((AbstractInsnNode)new InsnNode(3 + integer));
        } else if (integer <= 255) {
            insns.add((AbstractInsnNode)new IntInsnNode(16, integer));
        } else if (integer <= 65535) {
            insns.add((AbstractInsnNode)new IntInsnNode(17, integer));
        } else {
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)integer));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void appendConstantLoader(CompilationContext ctx, InsnList insns, Literal<?> literal, Class<?> type) throws CompilationException {
        Object obj;
        if (!literal.isStatic()) {
            int id = ctx.allocateDynamicLiteral(literal);
            BytecodeHelper.appendReferenceConstantGetter(ctx, insns, "DYNAMIC_LITERALS", id);
            return;
        }
        try {
            obj = literal.get(null);
        }
        catch (InvalidLiteralException e) {
            throw new CompilationException(e.failureCause, e.args);
        }
        if (!VALID_TYPES_IN_LDC.contains(obj.getClass())) {
            Pair<Integer, Integer> id = ctx.allocateStaticLiteral(literal);
            BytecodeHelper.appendReferenceConstantGetter(ctx, insns, "SC$" + id.getFirst(), (Integer)id.getSecond());
            if (!type.isPrimitive()) return;
            BytecodeHelper.appendPrimitiveUnwrapper(insns, type);
            return;
        }
        if (obj instanceof Byte) {
            insns.insert((AbstractInsnNode)new LdcInsnNode((Object)((Byte)obj).intValue()));
            insns.add((AbstractInsnNode)new InsnNode(145));
        } else if (obj instanceof Short) {
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)((Short)obj).intValue()));
            insns.add((AbstractInsnNode)new InsnNode(147));
        } else if (obj instanceof Character) {
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)Character.valueOf(((Character)obj).charValue())));
            insns.add((AbstractInsnNode)new InsnNode(146));
        } else if (obj instanceof Boolean) {
            insns.add((AbstractInsnNode)new LdcInsnNode((Object)((Boolean)obj != false ? 1 : 0)));
        } else {
            if (obj instanceof String) {
                insns.add((AbstractInsnNode)new LdcInsnNode(obj));
                return;
            }
            if (obj instanceof Class) {
                insns.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((Class)((Class)obj))));
                return;
            }
            insns.add((AbstractInsnNode)new LdcInsnNode(obj));
        }
        if (type.isPrimitive()) return;
        BytecodeHelper.appendPrimitiveWrapper(insns, type);
    }

    static void appendReferenceConstantGetter(CompilationContext ctx, InsnList insns, String fieldName, int cid) {
        insns.add((AbstractInsnNode)new FieldInsnNode(178, ctx.getInternalClassNameOfPath(), fieldName, UNCERTAIN_FIELD_DESCRIPTOR));
        BytecodeHelper.appendIntegerLoader(insns, cid);
        insns.add((AbstractInsnNode)new InsnNode(50));
    }

    static void appendAccessingFailureException(InsnList insns, FailureCause cause) {
        insns.add((AbstractInsnNode)new FieldInsnNode(178, "lovexyn0827/mess/util/access/FailureCause", cause.name(), "Llovexyn0827/mess/util/access/FailureCause;"));
        insns.add((AbstractInsnNode)new InsnNode(1));
        insns.add((AbstractInsnNode)new MethodInsnNode(184, "lovexyn0827/mess/util/access/AccessingFailureException", "create", "(Llovexyn0827/mess/util/access/FailureCause;Llovexyn0827/mess/util/access/Node;)Llovexyn0827/mess/util/access/AccessingFailureException;"));
        insns.add((AbstractInsnNode)new InsnNode(191));
    }

    static void appendCaller(InsnList insns, Member mem, CompilationContext.CallableType callableType) {
        if (mem != null) {
            boolean isStatic = Modifier.isStatic(mem.getModifiers());
            switch (callableType) {
                case INVOKER: {
                    Method m = (Method)mem;
                    String desc = Type.getMethodDescriptor((Method)m);
                    String operationDesc = !Modifier.isStatic(m.getModifiers()) ? desc.replace("(", "(" + Type.getDescriptor(m.getDeclaringClass())) : desc;
                    if (BytecodeHelper.canAccessDirectly(mem)) {
                        int opcode = isStatic ? 184 : (m.getDeclaringClass().isInterface() ? 185 : (Modifier.isPrivate(m.getModifiers()) ? 183 : 182));
                        insns.add((AbstractInsnNode)new MethodInsnNode(opcode, Type.getInternalName(m.getDeclaringClass()), m.getName(), desc));
                        break;
                    }
                    insns.add((AbstractInsnNode)new InvokeDynamicInsnNode("inDy_" + m.getName(), operationDesc, CompiledPath.METHOD_BSM_HANDLE, new Object[]{Type.getInternalName(m.getDeclaringClass()), m.getName(), desc}));
                    break;
                }
                case GETTER: {
                    Field f = (Field)mem;
                    if (BytecodeHelper.canAccessDirectly(mem)) {
                        int opcode = isStatic ? 178 : 180;
                        insns.add((AbstractInsnNode)new FieldInsnNode(opcode, Type.getInternalName(f.getDeclaringClass()), f.getName(), Type.getDescriptor(f.getType())));
                        break;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append('(');
                    if (!isStatic) {
                        sb.append(Type.getDescriptor(f.getDeclaringClass()));
                    }
                    sb.append(')');
                    sb.append(Type.getDescriptor(f.getType()));
                    String desc = sb.toString();
                    insns.add((AbstractInsnNode)new InvokeDynamicInsnNode("inDy_" + f.getName(), desc, CompiledPath.FIELD_BSM_HANDLE, new Object[]{Type.getInternalName(f.getDeclaringClass()), f.getName(), 0}));
                    break;
                }
                case SETTER: {
                    Field f1 = (Field)mem;
                    if (BytecodeHelper.canAccessDirectly(mem)) {
                        int opcode = isStatic ? 179 : 181;
                        insns.add((AbstractInsnNode)new FieldInsnNode(opcode, Type.getInternalName(f1.getDeclaringClass()), f1.getName(), Type.getDescriptor(f1.getType())));
                        break;
                    }
                    StringBuilder sb1 = new StringBuilder();
                    sb1.append('(');
                    if (!isStatic) {
                        sb1.append(Type.getDescriptor(f1.getDeclaringClass()));
                    }
                    sb1.append(Type.getDescriptor(f1.getType()));
                    sb1.append(")V");
                    String desc = sb1.toString();
                    insns.add((AbstractInsnNode)new InvokeDynamicInsnNode("inDy_" + f1.getName(), desc, CompiledPath.FIELD_BSM_HANDLE, new Object[]{Type.getInternalName(f1.getDeclaringClass()), f1.getName(), 1}));
                }
            }
        }
    }

    private static boolean canAccessDirectly(Member mem) {
        return Modifier.isPublic(mem.getModifiers()) && Modifier.isPublic(mem.getDeclaringClass().getModifiers());
    }

    static int appendLocalVarStorer(CompilationContext ctx, InsnList insns, Class<?> type) {
        if (type.isPrimitive()) {
            int slot;
            if (type == Float.TYPE) {
                slot = ctx.allocateLocalVar();
                insns.add((AbstractInsnNode)new VarInsnNode(56, slot));
            } else if (type == Long.TYPE) {
                slot = ctx.allocateWideLocalVar();
                insns.add((AbstractInsnNode)new VarInsnNode(55, slot));
            } else if (type == Double.TYPE) {
                slot = ctx.allocateWideLocalVar();
                insns.add((AbstractInsnNode)new VarInsnNode(57, slot));
            } else {
                slot = ctx.allocateLocalVar();
                insns.add((AbstractInsnNode)new VarInsnNode(54, slot));
            }
            return slot;
        }
        int slot = ctx.allocateLocalVar();
        insns.add((AbstractInsnNode)new VarInsnNode(58, slot));
        return slot;
    }

    static void appendLocalVarLoader(InsnList insns, int slot, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Float.TYPE) {
                insns.add((AbstractInsnNode)new VarInsnNode(23, slot));
            } else if (type == Long.TYPE) {
                insns.add((AbstractInsnNode)new VarInsnNode(22, slot));
            } else if (type == Double.TYPE) {
                insns.add((AbstractInsnNode)new VarInsnNode(24, slot));
            } else {
                insns.add((AbstractInsnNode)new VarInsnNode(21, slot));
            }
        } else {
            insns.add((AbstractInsnNode)new VarInsnNode(25, slot));
        }
    }

    public static void appendArrayElementLoader(InsnList insns, int index, Class<?> type) {
        BytecodeHelper.appendIntegerLoader(insns, index);
        switch (type.getName()) {
            case "int": {
                insns.add((AbstractInsnNode)new InsnNode(46));
                break;
            }
            case "double": {
                insns.add((AbstractInsnNode)new InsnNode(49));
                break;
            }
            case "float": {
                insns.add((AbstractInsnNode)new InsnNode(48));
                break;
            }
            case "long": {
                insns.add((AbstractInsnNode)new InsnNode(47));
                break;
            }
            case "short": {
                insns.add((AbstractInsnNode)new InsnNode(53));
                break;
            }
            case "char": {
                insns.add((AbstractInsnNode)new InsnNode(52));
                break;
            }
            case "boolean": 
            case "byte": {
                insns.add((AbstractInsnNode)new InsnNode(51));
                break;
            }
            default: {
                insns.add((AbstractInsnNode)new InsnNode(50));
            }
        }
    }
}

