/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.util.access;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.regex.Matcher;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.util.Reflection;
import lovexyn0827.mess.util.TranslatableException;
import lovexyn0827.mess.util.access.AccessingFailureException;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.access.ClassCastNode;
import lovexyn0827.mess.util.access.ComponentNode;
import lovexyn0827.mess.util.access.CustomNode;
import lovexyn0827.mess.util.access.ElementNode;
import lovexyn0827.mess.util.access.FieldNode;
import lovexyn0827.mess.util.access.JavaAccessingPath;
import lovexyn0827.mess.util.access.Literal;
import lovexyn0827.mess.util.access.LiteralNode;
import lovexyn0827.mess.util.access.MapperNode;
import lovexyn0827.mess.util.access.MethodNode;
import lovexyn0827.mess.util.access.Node;
import lovexyn0827.mess.util.access.SimpleNode;
import lovexyn0827.mess.util.access.SizeNode;
import lovexyn0827.mess.util.access.ValueOfMapNode;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2321;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public final class AccessingPathArgumentType
implements ArgumentType<AccessingPath> {
    private final Function<CommandContext<class_2168>, Type> inputTypeGetter;

    private AccessingPathArgumentType() {
        this.inputTypeGetter = null;
    }

    private AccessingPathArgumentType(Function<CommandContext<class_2168>, Type> inputTypeGetter) {
        this.inputTypeGetter = inputTypeGetter;
    }

    public static AccessingPathArgumentType accessingPathArg() {
        return new AccessingPathArgumentType();
    }

    public static AccessingPathArgumentType accessingPathArg(Function<CommandContext<class_2168>, Type> inputTypeGetter) {
        return new AccessingPathArgumentType(inputTypeGetter);
    }

    public static AccessingPathArgumentType accessingPathArg(Class<?> out) {
        return new AccessingPathArgumentType(ct -> out);
    }

    public static AccessingPath getAccessingPath(CommandContext<class_2168> ct, String string) {
        return (AccessingPath)ct.getArgument(string, AccessingPath.class);
    }

    public AccessingPath parse(StringReader reader) throws CommandSyntaxException {
        Node n;
        LinkedList nodes = Lists.newLinkedList();
        String stringRepresentation = reader.getRemaining().trim();
        reader.setCursor(reader.getTotalLength());
        if (!stringRepresentation.endsWith(".")) {
            stringRepresentation = stringRepresentation + '.';
        }
        StringReader sr = new StringReader(stringRepresentation);
        int i = 0;
        while ((n = this.readNode(sr)) != null) {
            if (!nodes.isEmpty() && !n.canFollow((Node)nodes.getLast()) && OptionManager.strictAccessingPathParsing) {
                throw new TranslatableException("Node %s (%s) couldn't follow %s (%s)", n.getClass().getSimpleName(), n, ((Node)nodes.getLast()).getClass().getSimpleName(), nodes.getLast());
            }
            n.ordinary = i++;
            nodes.add(n);
        }
        return new JavaAccessingPath(nodes, stringRepresentation);
    }

    @Nullable
    private Node readNode(StringReader sr) throws CommandSyntaxException {
        if (!sr.canRead()) {
            return null;
        }
        switch (sr.peek()) {
            case '!': {
                sr.skip();
                String nodeStr = sr.readStringUntil('.');
                return new FieldNode(nodeStr);
            }
            case '[': {
                sr.skip();
                String nodeStr = sr.readStringUntil(']');
                sr.skip();
                try {
                    return new ElementNode(Integer.parseInt(nodeStr));
                }
                catch (NumberFormatException e) {
                    throw new TranslatableException("exp.reqint", nodeStr);
                }
            }
            case '<': {
                String nodeStr = AccessingPathArgumentType.readWrapped(sr, '<', '>');
                sr.skip();
                return new ValueOfMapNode(Literal.parse(nodeStr));
            }
            case '>': {
                sr.skip();
                String nodeStr = AccessingPathArgumentType.readUntil(sr, '.');
                return new MapperNode(nodeStr);
            }
            case '(': {
                sr.skip();
                String nodeStr = sr.readStringUntil(')');
                sr.skip();
                return new ClassCastNode(nodeStr);
            }
            case '*': {
                sr.skip();
                String nodeStr = sr.readStringUntil('.');
                return new LiteralNode(nodeStr);
            }
        }
        String nodeStr = AccessingPathArgumentType.readUntil(sr, '.');
        Matcher matcher = MethodNode.METHOD_PATTERN.matcher(nodeStr);
        if (matcher.matches()) {
            return new MethodNode(matcher.group("name"), matcher.group("types"), matcher.group("args"));
        }
        switch (nodeStr) {
            case "x": {
                return new ComponentNode.X();
            }
            case "y": {
                return new ComponentNode.Y();
            }
            case "z": {
                return new ComponentNode.Z();
            }
            case "size": {
                return new SizeNode();
            }
        }
        Node node = SimpleNode.byName(nodeStr);
        if (node != null) {
            return node;
        }
        node = CustomNode.byName(nodeStr);
        if (node != null) {
            return node;
        }
        throw new TranslatableException("exp.unknownnode", nodeStr);
    }

    private static String readWrapped(StringReader sr, char openCh, char closeCh) throws CommandSyntaxException {
        int depth = 0;
        int start = sr.getCursor();
        int end = -1;
        while (sr.canRead()) {
            char ch = sr.read();
            if (ch == '\\') {
                sr.skip();
                continue;
            }
            if (ch == openCh) {
                ++depth;
                continue;
            }
            if (ch != closeCh || --depth != 0) continue;
            end = sr.getCursor();
            break;
        }
        if (end == -1) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedEndOfQuote().createWithContext((ImmutableStringReader)sr);
        }
        return sr.getString().substring(start + 1, end - 1);
    }

    private static String readUntil(StringReader sr, char endCh) throws CommandSyntaxException {
        int start = sr.getCursor();
        int end = -1;
        while (sr.canRead()) {
            char ch = sr.read();
            if (ch == '\\') {
                sr.skip();
                continue;
            }
            if (ch != endCh) continue;
            end = sr.getCursor();
            break;
        }
        if (end == -1) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedEndOfQuote().createWithContext((ImmutableStringReader)sr);
        }
        return sr.getString().substring(start, end - 1);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ct, SuggestionsBuilder unoffsetedBuilder) {
        String in = unoffsetedBuilder.getRemaining();
        int len = in.length();
        int lastNotEscapedDot = -1;
        for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != '.') continue;
            lastNotEscapedDot = i;
        }
        int offset = unoffsetedBuilder.getStart() + lastNotEscapedDot + 1;
        SuggestionsBuilder builder = unoffsetedBuilder.createOffset(offset);
        if (lastNotEscapedDot == len - 1) {
            CustomNode.listSuggestions(builder);
            SimpleNode.appendSuggestions(builder);
            return builder.suggest(">").suggest("!").suggest("<").suggest("[").suggest("(").suggest("*").suggest("x").suggest("y").suggest("z").suggest("size").buildFuture();
        }
        String lastNodeStr = in.substring(lastNotEscapedDot + 1);
        switch (lastNodeStr.charAt(0)) {
            case '>': {
                return builder.suggest(">java/lang/").suggest(">java/util/").suggest(">net/minecraft/").suggest(">net/minecraft/block").suggest(">net/minecraft/entity").suggest(">net/minecraft/world").suggest(">net/minecraft/util").suggest(lastNodeStr + "::").buildFuture();
            }
        }
        if (OptionManager.accessingPathDynamicAutoCompletion) {
            if (this.inputTypeGetter != null && ct.getSource() instanceof class_2168) {
                AccessingPath completed;
                Type inType = this.inputTypeGetter.apply(ct);
                String completedStr = in.substring(0, lastNotEscapedDot + 1);
                try {
                    completed = completedStr.isEmpty() ? AccessingPath.DUMMY : this.parse(new StringReader(completedStr));
                }
                catch (CommandSyntaxException e) {
                    completed = AccessingPath.DUMMY;
                }
                if (completed instanceof JavaAccessingPath) {
                    try {
                        ((JavaAccessingPath)completed).initialize(inType);
                    }
                    catch (AccessingFailureException e) {
                        return builder.buildFuture();
                    }
                }
                if (lastNodeStr.charAt(0) == '!') {
                    String prefix = lastNodeStr.substring(1);
                    Reflection.getAvailableFieldNames(Reflection.getRawType(completed.getOutputType())).stream().filter(fn -> fn.contains(prefix) || prefix.isEmpty()).forEach(fn -> builder.suggest("!" + fn));
                    builder.suggest(".");
                } else {
                    String prefix = lastNodeStr;
                    MutableBoolean anyExactlyMatching = new MutableBoolean(false);
                    Reflection.getAllMethods(Reflection.getRawType(completed.getOutputType())).stream().map(m -> MessMod.INSTANCE.getMapping().namedMethod(m.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)m))).filter(mn -> mn.contains(prefix)).distinct().forEach(mn -> {
                        builder.suggest(mn);
                        if (mn.equals(prefix)) {
                            anyExactlyMatching.setTrue();
                        }
                    });
                    if (anyExactlyMatching.booleanValue()) {
                        builder.suggest("<").suggest("(");
                    }
                }
            } else if (!(ct.getSource() instanceof class_2168)) {
                try {
                    CommandContext<S> clientCt = ct;
                    return class_2321.field_10933.getSuggestions(clientCt, builder);
                }
                catch (CommandSyntaxException e) {
                    MessMod.LOGGER.error("Unable to ask the server for suggestions!");
                    e.printStackTrace();
                }
            }
        }
        return builder.buildFuture();
    }

    public static void registerArgumentType() {
        class_2316.method_10017((String)"mess_accessing_path", AccessingPathArgumentType.class, (class_2314)new class_2319(AccessingPathArgumentType::accessingPathArg));
    }
}

