/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.options;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.context.CommandContext;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.mixins.WorldSavePathMixin;
import lovexyn0827.mess.options.BooleanParser;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.Label;
import lovexyn0827.mess.options.Option;
import lovexyn0827.mess.options.OptionSet;
import lovexyn0827.mess.options.OptionWrapper;
import lovexyn0827.mess.util.access.AccessingPath;
import lovexyn0827.mess.util.blame.BlamingMode;
import lovexyn0827.mess.util.blame.Confidence;
import lovexyn0827.mess.util.i18n.I18N;
import lovexyn0827.mess.util.i18n.Language;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OptionManager {
    private static final Set<Class<?>> OPTION_CLASSES = Sets.newHashSet();
    public static final SortedMap<String, OptionWrapper> OPTIONS;
    private static OptionSet activeOptionSet;
    static final Map<String, CustomOptionApplicator> CUSTOM_APPLICATION_BEHAVIORS;
    static final Map<String, CustomOptionValidator> CUSTOM_OPTION_VALIDATORS;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean accessingPathDynamicAutoCompletion;
    @Option(defaultValue="STANDARD", parserClass=AccessingPath.InitializationStrategy.Parser.class, label={Label.MESSMOD})
    public static AccessingPath.InitializationStrategy accessingPathInitStrategy;
    @Option(defaultValue="POSSIBLE", parserClass=Confidence.Parser.class, label={Label.MESSMOD})
    public static Confidence blameThreshold;
    @Option(defaultValue="DISABLED", parserClass=BlamingMode.Parser.class, label={Label.MESSMOD})
    public static BlamingMode blamingMode;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean commandExecutionRequirment;
    @Option(defaultValue="true", parserClass=BooleanParser.class, label={Label.RESEARCH, Label.MESSMOD})
    public static boolean directChunkAccessForMessMod;
    @Option(defaultValue="false", parserClass=BooleanParser.class, globalOnly=true, environment={EnvType.CLIENT}, label={Label.MISC, Label.MESSMOD})
    public static boolean hideSurvivalSaves;
    @Option(defaultValue="-FOLLOW_SYSTEM_SETTINGS-", parserClass=Language.Parser.class, label={Label.MESSMOD})
    public static String language;
    @Option(defaultValue="false", experimental=true, parserClass=BooleanParser.class, label={Label.MESSMOD})
    public static boolean strictAccessingPathParsing;
    @Option(defaultValue="false", experimental=true, parserClass=BooleanParser.class, label={Label.MISC})
    public static boolean superSuperSecretSetting;

    private static void setOptionSet(OptionSet set) {
        activeOptionSet = set;
        set.activiate();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            MessMod.LOGGER.info("Loaded {} MessMod config from {}", (Object)OPTIONS.size(), (Object)set.getReadablePathStr());
            OPTIONS.values().stream().map(o -> o.name + ": " + set.getSerialized(o.name)).forEach(arg_0 -> ((Logger)MessMod.LOGGER).info(arg_0));
        }
    }

    public static boolean isValidOptionName(String name) {
        return OPTIONS.containsKey(name);
    }

    public static void onReceivedOptions(class_2540 in) throws IOException {
        OptionManager.setOptionSet(OptionSet.fromPacket(in));
    }

    public static void registerCustomApplicator(String name, CustomOptionApplicator behavior) {
        CUSTOM_APPLICATION_BEHAVIORS.put(name, behavior);
    }

    public static void registerCustomValidator(String name, CustomOptionValidator validator) {
        CUSTOM_OPTION_VALIDATORS.put(name, validator);
    }

    public static void registerCustomHandlers(String name, CustomOptionValidator validator, CustomOptionApplicator behavior) {
        CUSTOM_APPLICATION_BEHAVIORS.put(name, behavior);
        CUSTOM_OPTION_VALIDATORS.put(name, validator);
    }

    public static void updateServer(@Nullable MinecraftServer ms) {
        if (ms != null) {
            Path p = ms.method_27050(WorldSavePathMixin.create("mcwmem.prop"));
            OptionManager.setOptionSet(OptionSet.load(p.toFile()));
        } else {
            activeOptionSet.save();
            OptionManager.setOptionSet(OptionSet.GLOBAL);
        }
    }

    public static void loadFromRemoteServer(class_2540 data) {
        OptionManager.setOptionSet(OptionSet.fromPacket(data));
    }

    public static void loadSingleFromRemoteServer(class_2540 data) {
        if (activeOptionSet == OptionSet.GLOBAL) {
            MessMod.LOGGER.error("Trying to load options to global option set!");
            return;
        }
        String name = data.method_19772();
        String value = data.method_19772();
        try {
            activeOptionSet.set(name, value);
        }
        catch (InvalidOptionException e) {
            MessMod.LOGGER.error("Received incorrect option {}={}: {}", (Object)name, (Object)value, (Object)e.getLocalizedMessage());
        }
    }

    public static void reload() {
        activeOptionSet.reload();
    }

    public static void sendOptionsTo(class_3222 player) {
        player.field_13987.method_14364((class_2596)activeOptionSet.toPacket());
    }

    public static OptionSet getActiveOptionSet() {
        return activeOptionSet;
    }

    public static OptionSet getGlobalOptionSet() {
        return OptionSet.GLOBAL;
    }

    static {
        CUSTOM_APPLICATION_BEHAVIORS = Maps.newHashMap();
        CUSTOM_OPTION_VALIDATORS = Maps.newHashMap();
        OptionManager.registerCustomHandlers("language", (newVal, ct) -> {
            boolean forceLoad = ((String)newVal).endsWith("_FORCELOAD");
            String id = ((String)newVal).replace("_FORCELOAD", "");
            if (!I18N.canUseLanguage(id, forceLoad)) {
                throw new InvalidOptionException("Language " + id + " is unsupported or incomplete.", new Object[0]);
            }
        }, (newVal, ct) -> {
            boolean forceLoad = ((String)newVal).endsWith("_FORCELOAD");
            String id = ((String)newVal).replace("_FORCELOAD", "");
            if (!I18N.setLanguage(id, forceLoad)) {
                throw new IllegalStateException("Option language is not validated!");
            }
        });
        OPTION_CLASSES.add(OptionManager.class);
        MessMod.getComponents().forEach(c -> {
            Class<?> cl = c.getOptionClass();
            if (cl == null) {
                return;
            }
            if (!OPTION_CLASSES.add(c.getOptionClass())) {
                throw new IllegalStateException("Option class " + cl + " has already been registered.");
            }
        });
        OPTIONS = OPTION_CLASSES.stream().map(Class::getFields).flatMap(Stream::of).filter(f -> f.isAnnotationPresent(Option.class)).sorted((a, b) -> Comparator.naturalOrder().compare(a.getName(), b.getName())).collect(TreeMap::new, (map, f) -> map.put(f.getName(), new OptionWrapper((Field)f)), Map::putAll);
        OPTIONS.values().forEach(o -> {
            if (!I18N.EN_US.containsKey(String.format("opt.%s.desc", o.name))) {
                MessMod.LOGGER.warn("The description of option {} is missing!", (Object)o.name);
            }
        });
        OptionManager.setOptionSet(OptionSet.GLOBAL);
    }

    @FunctionalInterface
    static interface CustomOptionValidator {
        public void validate(@Nullable Object var1, @Nullable CommandContext<class_2168> var2) throws InvalidOptionException;
    }

    @FunctionalInterface
    static interface CustomOptionApplicator {
        public void onOptionUpdate(Object var1, @Nullable CommandContext<class_2168> var2);
    }
}

