/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.network;

import com.google.common.collect.Maps;
import java.util.Map;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.mixins.CustomPayloadC2SPacketAccessor;
import lovexyn0827.mess.network.Channels;
import lovexyn0827.mess.util.FormattedText;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class MessServerNetworkHandler {
    private static final Map<class_2960, PacketHandler> PACKET_HANDLERS = Maps.newHashMap();
    private final MinecraftServer server;

    public MessServerNetworkHandler(MinecraftServer server) {
        this.server = server;
    }

    public boolean handlePacket(class_2817 packet, class_3222 player) {
        try {
            CustomPayloadC2SPacketAccessor accessor = (CustomPayloadC2SPacketAccessor)packet;
            class_2960 channel = accessor.getMessChannel();
            class_2540 buf = accessor.getMessData();
            PacketHandler handler = PACKET_HANDLERS.get(channel);
            if (handler != null) {
                handler.onPacket(player, channel, buf);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static void register(class_2960 hud, PacketHandler handler) {
        PACKET_HANDLERS.put(hud, handler);
    }

    public void sendToEveryone(class_2658 packet) {
        this.server.method_3760().method_14581((class_2596)packet);
    }

    static {
        MessServerNetworkHandler.register(Channels.VERSION, (player, channel, buf) -> {
            int protocol = buf.readInt();
            String ver = buf.method_10800(Short.MAX_VALUE);
            MessMod.LOGGER.info("Player {} joined the game with MessMod {} (Protocol Version: {})", (Object)player.method_5477().method_10851(), (Object)ver, (Object)protocol);
            if (protocol != 9) {
                MessMod.LOGGER.warn("But note that the protocol version of the client differs from the one here.");
                player.method_7353((class_2561)new FormattedText("misc.protver.err", "c").asMutableText(), false);
            }
        });
        MessMod.getComponents().forEach(c -> c.registerServerPackerHandlers(MessServerNetworkHandler::register));
    }

    public static interface PacketHandler {
        public void onPacket(class_3222 var1, class_2960 var2, class_2540 var3);
    }
}

