/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.network;

import com.google.common.collect.Maps;
import io.netty.buffer.Unpooled;
import java.util.Map;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.network.Channels;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.rendering.RemoteShapeCache;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class MessClientNetworkHandler {
    private static final Map<class_2960, PacketHandler> PACKET_HANDLERS = Maps.newHashMap();
    private class_310 client;

    public MessClientNetworkHandler(class_310 mc) {
        this.client = mc;
    }

    public boolean handlePacket(class_2658 packet) {
        try {
            class_2960 id = packet.method_11456();
            PacketHandler handler = PACKET_HANDLERS.get(id);
            if (handler != null) {
                handler.onPacket(packet, this.client);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void send(class_2817 packet) {
        class_634 handler = this.client.method_1562();
        if (handler != null) {
            handler.method_2883((class_2596)packet);
        }
    }

    public void sendVersion() {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(9);
        buf.method_10814(((ModContainer)FabricLoader.getInstance().getModContainer("messcore").get()).getMetadata().getVersion().getFriendlyString());
        class_2817 packet = new class_2817(Channels.VERSION, buf);
        this.send(packet);
    }

    private static void register(class_2960 id, PacketHandler handler) {
        PACKET_HANDLERS.put(id, handler);
    }

    static {
        MessClientNetworkHandler.register(Channels.SHAPE, (packet, client) -> ((RemoteShapeCache)MessMod.INSTANCE.shapeCache).handlePacket(packet));
        MessClientNetworkHandler.register(Channels.OPTIONS, (packet, client) -> client.execute(() -> OptionManager.loadFromRemoteServer(packet.method_11458())));
        MessClientNetworkHandler.register(Channels.OPTION_SINGLE, (packet, client) -> client.execute(() -> OptionManager.loadSingleFromRemoteServer(packet.method_11458())));
        MessMod.getComponents().forEach(c -> c.registerClientPackerHandlers(MessClientNetworkHandler::register));
    }

    public static interface PacketHandler {
        public void onPacket(class_2658 var1, class_310 var2);
    }
}

