/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import lovexyn0827.mess.MessMod;
import lovexyn0827.mess.MessModMixinPlugin;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.options.InvalidOptionException;
import lovexyn0827.mess.options.Label;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.options.OptionWrapper;
import lovexyn0827.mess.util.FormattedText;
import lovexyn0827.mess.util.i18n.I18N;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_5250;

public class MessCfgCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        Command listAllCmd = ct -> {
            ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("messcore").get()).getMetadata();
            class_2168 s = (class_2168)ct.getSource();
            s.method_9226((class_2561)new class_2585(metadata.getName() + " " + metadata.getVersion()).method_27692(class_124.field_1067), false);
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.messcfg.compcnt", MessMod.getComponents().size());
            s.method_9226((class_2561)new FormattedText("cmd.messcfg.list", "l").asMutableText(), false);
            OptionManager.OPTIONS.forEach((name, opt) -> MessCfgCommand.dumpOption(s, name, opt));
            return 1;
        };
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"messcfg").requires(CommandUtil.COMMAND_REQUMENT)).executes(listAllCmd)).then(class_2170.method_9247((String)"reloadConfig").executes(ct -> {
            OptionManager.reload();
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.messcfg.reload");
            return 1;
        }))).then(class_2170.method_9247((String)"reloadMapping").executes(ct -> {
            MessMod.INSTANCE.reloadMapping();
            CommandUtil.feedback((CommandContext<? extends class_2168>)ct, "cmd.messcfg.reloadmapping");
            return 1;
        }))).then(class_2170.method_9247((String)"listComponents").executes(ct -> {
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.messcfg.compcnt", MessMod.getComponents().size());
            MessMod.getComponents().forEach(c -> {
                ModMetadata meta = ((ModContainer)FabricLoader.getInstance().getModContainer(c.modid()).get()).getMetadata();
                class_2585 line = new class_2585(" - " + meta.getName());
                line.method_27694(s -> s.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(meta.getDescription()))));
                ((class_2168)ct.getSource()).method_9226((class_2561)line, false);
            });
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").executes(listAllCmd)).then(class_2170.method_9244((String)"label", (ArgumentType)StringArgumentType.word()).suggests(CommandUtil.immutableSuggestionsOfEnum(Label.class)).executes(ct -> {
            Label label;
            String lName = StringArgumentType.getString((CommandContext)ct, (String)"label");
            try {
                label = Label.valueOf(lName);
            }
            catch (IllegalArgumentException e) {
                CommandUtil.errorWithArgs((CommandContext<? extends class_2168>)ct, "cmd.general.nodef", lName);
                return 0;
            }
            CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.messcfg.withtag", lName);
            class_2168 s = (class_2168)ct.getSource();
            OptionManager.OPTIONS.forEach((name, opt) -> {
                for (Label l0 : opt.labels()) {
                    if (l0 != label) continue;
                    MessCfgCommand.dumpOption(s, name, opt);
                    break;
                }
            });
            return 1;
        })));
        OptionManager.OPTIONS.forEach((name, opt) -> {
            SuggestionProvider<class_2168> sp = opt.getSuggestions();
            command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtil.COMMAND_REQUMENT)).executes(ct -> {
                class_5250 text = new FormattedText((String)name, "a", false, new Object[0]).asMutableText();
                if (opt.isExperimental()) {
                    text.method_10852((class_2561)new FormattedText("cmd.messcfg.exp", "rcl").asMutableText());
                }
                text.method_10852((class_2561)new class_2585("\n" + opt.getDescription() + "\n").method_27692(class_124.field_1080));
                String value = OptionManager.getActiveOptionSet().getSerialized((String)name);
                text.method_10852((class_2561)new FormattedText("cmd.messcfg.current", "f", true, value).asMutableText());
                if (!opt.getDefaultValue().equals(value)) {
                    text.method_10852((class_2561)new FormattedText("cmd.messcfg.modified", "cl").asMutableText());
                }
                String globalValue = OptionManager.getGlobalOptionSet().getSerialized((String)name);
                text.method_10852((class_2561)new FormattedText("cmd.messcfg.global", "f", true, globalValue).asMutableText());
                if (!opt.getDefaultValue().equals(globalValue)) {
                    text.method_10852((class_2561)new FormattedText("cmd.messcfg.modified", "cl").asMutableText());
                }
                text.method_10852((class_2561)new FormattedText("cmd.messcfg.default", "f", true, opt.getDefaultValue()).asMutableText());
                ((class_2168)ct.getSource()).method_9226((class_2561)text, false);
                return 1;
            })).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(sp).executes(ct -> {
                if (MessCfgCommand.checkMixins((CommandContext<class_2168>)ct, name)) {
                    String value = StringArgumentType.getString((CommandContext)ct, (String)"value");
                    if (opt.globalOnly()) {
                        class_5250 errMsg = new class_2585(I18N.translate("cmd.messcfg.globalonly", name)).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11745, "/messcfg setGlobal " + name + ' ' + value)));
                        ((class_2168)ct.getSource()).method_9213((class_2561)errMsg);
                        return -1;
                    }
                    try {
                        OptionManager.getActiveOptionSet().set((String)name, value, (CommandContext<class_2168>)ct);
                        CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.messcfg.set", name, value);
                        return 1;
                    }
                    catch (InvalidOptionException e) {
                        CommandUtil.error((CommandContext<? extends class_2168>)ct, e.getMessage());
                        return -1;
                    }
                }
                return 0;
            })));
            command.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"setGlobal").requires(CommandUtil.COMMAND_REQUMENT)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CommandUtil.COMMAND_REQUMENT)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).suggests(sp).executes(ct -> {
                if (MessCfgCommand.checkMixins((CommandContext<class_2168>)ct, name)) {
                    try {
                        String value = StringArgumentType.getString((CommandContext)ct, (String)"value");
                        OptionManager.getGlobalOptionSet().set((String)name, value, (CommandContext<class_2168>)ct);
                        CommandUtil.feedbackWithArgs((CommandContext<? extends class_2168>)ct, "cmd.messcfg.setglobal", name, value);
                        return 1;
                    }
                    catch (InvalidOptionException e) {
                        e.printStackTrace();
                        CommandUtil.error((CommandContext<? extends class_2168>)ct, e.getMessage());
                        return -1;
                    }
                }
                return 0;
            }))));
        });
        dispatcher.register(command);
    }

    private static void dumpOption(class_2168 source, String name, OptionWrapper opt) {
        String v = OptionManager.getActiveOptionSet().getSerialized(name);
        class_2558 event = new class_2558(class_2558.class_2559.field_11745, "/messcfg " + name);
        class_5250 text = new class_2585(name + ": " + v).method_27696(class_2583.field_24360.method_10958(event).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(opt.getDescription())))).method_27692(class_124.field_1080);
        boolean modified = !v.equals(opt.getDefaultValue());
        source.method_9226((class_2561)(modified ? text.method_10852((class_2561)new FormattedText("cmd.messcfg.modified", "cl").asMutableText()) : text), false);
    }

    private static boolean checkMixins(CommandContext<class_2168> ct, String name) {
        if (MessModMixinPlugin.isFeatureAvailable(name)) {
            return true;
        }
        for (String mixin : MessModMixinPlugin.getAbsentMixins(name)) {
            CommandUtil.errorWithArgs(ct, "cmd.general.reqmixin", name, mixin);
        }
        return false;
    }
}

