/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess;

import com.google.common.collect.ImmutableSet;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class MessModMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String MESSMOD_MIXINS = "lovexyn0827.mess.mixins.";
    private static final File ADVANCED_MIXINS_CONFIGURATION = new File("advanced_mixins.prop");
    private static final Map<String, BooleanSupplier> CUSTOM_MINIX_REQUIREMENTS = new HashMap<String, BooleanSupplier>();
    private static final ImmutableSet<MixinInfo> ADVANCED_MIXINS;
    private static final ImmutableSet<String> ACTIVIATED_ADVANCED_MIXINS;
    private static final Map<String, Set<String>> ADVANCED_MIXINS_BY_USAGES;
    private static final Map<String, Set<String>> ABSENT_ADVANCED_MIXINS_BY_USAGES;

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassNameFull) {
        String mixinClassName = mixinClassNameFull.replace(MESSMOD_MIXINS, "");
        if (ADVANCED_MIXINS.stream().anyMatch(m -> m.name.equals(mixinClassName)) && !ACTIVIATED_ADVANCED_MIXINS.contains((Object)mixinClassName)) {
            return false;
        }
        try {
            if (CUSTOM_MINIX_REQUIREMENTS.containsKey(mixinClassName)) {
                return CUSTOM_MINIX_REQUIREMENTS.get(mixinClassName).getAsBoolean();
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to determine whether or not mixin {} should be applied!", (Object)mixinClassName);
            e.printStackTrace();
            return true;
        }
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static BooleanSupplier isModLoaded(String id, @Nullable String minVer, @Nullable String maxVer) {
        SemanticVersion maxSemiVer;
        SemanticVersion minSemiVer;
        Optional mayMod = FabricLoader.getInstance().getModContainer(id);
        try {
            minSemiVer = minVer != null ? SemanticVersion.parse((String)minVer) : null;
            maxSemiVer = maxVer != null ? SemanticVersion.parse((String)maxVer) : null;
        }
        catch (VersionParsingException e) {
            throw new IllegalArgumentException();
        }
        return () -> {
            if (mayMod.isPresent()) {
                Version ver = ((ModContainer)mayMod.get()).getMetadata().getVersion();
                if (ver instanceof SemanticVersion) {
                    SemanticVersion semVer = (SemanticVersion)ver;
                    return !(maxSemiVer != null && maxSemiVer.compareTo(semVer) < 0 || minSemiVer != null && minSemiVer.compareTo(semVer) > 0);
                }
                return true;
            }
            return true;
        };
    }

    private static BooleanSupplier isModNotLoaded(String id, @Nullable String minVer, @Nullable String maxVer) {
        return () -> !MessModMixinPlugin.isModLoaded(id, minVer, maxVer).getAsBoolean();
    }

    private static ImmutableSet<String> getActiviatedAdvancedMixins(ImmutableSet<MixinInfo> advancedMixins) {
        try {
            Properties config = MessModMixinPlugin.loadConfig(advancedMixins);
            if ("true".equals(System.clearProperty("messmod.chooseMixin"))) {
                MessModMixinPlugin.tryOpenMixinChoosingFrame(config);
            }
            try (FileWriter fw = new FileWriter(ADVANCED_MIXINS_CONFIGURATION);){
                config.store(fw, "Advanced Mixins of MessMod");
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            config.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> {
                if ("true".equals(value)) {
                    builder.add((Object)((String)name));
                }
            }));
            return builder.build();
        }
        catch (Exception e) {
            LOGGER.fatal("Failed to load activation config of advanced mixins!");
            e.printStackTrace();
            return ImmutableSet.of();
        }
    }

    private static Properties loadConfig(ImmutableSet<MixinInfo> advancedMixins) throws IOException {
        Properties config = new Properties();
        if (!ADVANCED_MIXINS_CONFIGURATION.exists()) {
            ADVANCED_MIXINS_CONFIGURATION.createNewFile();
        }
        try (FileReader fr = new FileReader(ADVANCED_MIXINS_CONFIGURATION);){
            config.load(fr);
            ADVANCED_MIXINS.forEach(info -> {
                if (Boolean.parseBoolean((String)config.computeIfAbsent(info.name, (Function<? super Object, ?>)((Function<Object, Object>)k -> "true")))) {
                    config.put(info.name, "true");
                }
            });
        }
        advancedMixins.forEach(entry -> config.computeIfAbsent(entry.name, (Function<? super Object, ?>)((Function<Object, Object>)k -> "true")));
        return config;
    }

    public static void tryOpenMixinChoosingFrame(Properties initial) {
        try {
            if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
                return;
            }
            System.setProperty("java.awt.headless", "false");
            initial = initial == null ? MessModMixinPlugin.loadConfig(ADVANCED_MIXINS) : initial;
            MixinChoosingFrame frame = new MixinChoosingFrame(initial);
            frame.setVisible(true);
            while (frame.choosing && frame.isVisible()) {
            }
            frame.writeChoices(initial);
        }
        catch (Throwable e) {
            LOGGER.error("Failed to display mixin choosing window!");
            e.printStackTrace();
        }
    }

    public static Set<String> getAbsentMixins(String usage) {
        return Collections.unmodifiableSet(ABSENT_ADVANCED_MIXINS_BY_USAGES.get(usage));
    }

    public static boolean isFeatureAvailable(String usage) {
        return ABSENT_ADVANCED_MIXINS_BY_USAGES.get(usage) == null;
    }

    static {
        ADVANCED_MIXINS_BY_USAGES = new HashMap<String, Set<String>>();
        ABSENT_ADVANCED_MIXINS_BY_USAGES = new HashMap<String, Set<String>>();
        CUSTOM_MINIX_REQUIREMENTS.put("StructureBlockBlockEntityMixin", MessModMixinPlugin.isModNotLoaded("carpet", "1.4.25", null));
        ADVANCED_MIXINS = AdvancedMixinInfoBuilder.create().build();
        ACTIVIATED_ADVANCED_MIXINS = MessModMixinPlugin.getActiviatedAdvancedMixins(ADVANCED_MIXINS);
        ADVANCED_MIXINS.forEach(info -> {
            for (String usage : info.usages) {
                ADVANCED_MIXINS_BY_USAGES.computeIfAbsent(usage, k -> new HashSet()).add(info.name);
                if (ACTIVIATED_ADVANCED_MIXINS.contains((Object)info.name)) continue;
                ABSENT_ADVANCED_MIXINS_BY_USAGES.computeIfAbsent(usage, k -> new HashSet()).add(info.name);
            }
        });
    }

    private static final class MixinChoosingFrame
    extends JFrame {
        private static final long serialVersionUID = 2370884454946517091L;
        private final Map<String, JCheckBox> mixins = new HashMap<String, JCheckBox>();
        protected volatile boolean choosing = true;

        protected MixinChoosingFrame(Properties initial) {
            this.setLayout(new GridLayout(0, 3, 3, 3));
            this.add(new JLabel("Name of Mixin"));
            this.add(new JLabel("Usage"));
            this.add(new JLabel("Impacts"));
            ADVANCED_MIXINS.forEach(s -> {
                JCheckBox check = new JCheckBox(s.name);
                if ("true".equals(initial.get(s.name))) {
                    check.setSelected(true);
                }
                this.mixins.put(s.name, check);
                this.add(check);
                this.add(new JLabel(String.join((CharSequence)", ", s.usages)));
                this.add(new JLabel(s.impacts));
            });
            JButton doneBtn = new JButton("OK");
            doneBtn.addActionListener(ae -> {
                this.choosing = false;
                this.dispose();
            });
            this.add(doneBtn);
            this.setSize(800, ADVANCED_MIXINS.size() * 32 + 64);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    choosing = false;
                    this.dispose();
                }
            });
        }

        public void writeChoices(Properties config) {
            this.mixins.forEach((name, check) -> config.put(name, Boolean.toString(check.isSelected())));
            try (FileWriter fw = new FileWriter(ADVANCED_MIXINS_CONFIGURATION);){
                config.store(fw, "Advanced Mixins of MessMod");
            }
            catch (IOException e) {
                LOGGER.error("Unable to write advanced mixin configuration!");
                e.printStackTrace();
            }
        }
    }

    private static final class MixinInfo {
        public final String name;
        public final String[] usages;
        public final String impacts;

        public MixinInfo(String name, Set<String> usages, String impacts) {
            this.name = name;
            this.usages = usages.toArray(new String[usages.size()]);
            this.impacts = impacts;
        }
    }

    private static final class AdvancedMixinInfoBuilder {
        private List<MixinInfo> infoList = new ArrayList<MixinInfo>();
        private String currentMixin;
        private Set<String> usages;
        private String impacts;

        private AdvancedMixinInfoBuilder() {
        }

        protected static AdvancedMixinInfoBuilder create() {
            return new AdvancedMixinInfoBuilder();
        }

        protected AdvancedMixinInfoBuilder add(String name) {
            if (this.currentMixin != null) {
                this.infoList.add(new MixinInfo(this.currentMixin, this.usages, this.impacts));
            }
            this.currentMixin = name;
            this.usages = new HashSet<String>();
            this.impacts = "";
            return this;
        }

        protected AdvancedMixinInfoBuilder addUsages(String ... usages) {
            for (String usage : usages) {
                this.usages.add(usage);
            }
            return this;
        }

        protected AdvancedMixinInfoBuilder costly() {
            this.impacts = this.impacts + "High performance cost|";
            return this;
        }

        protected AdvancedMixinInfoBuilder risky() {
            this.impacts = this.impacts + "Poiential issues|";
            return this;
        }

        protected AdvancedMixinInfoBuilder compatibility() {
            this.impacts = this.impacts + "Compatibility issues|";
            return this;
        }

        protected AdvancedMixinInfoBuilder compatibility(String ... modids) {
            this.impacts = this.impacts + "Compatibility issues with " + String.join((CharSequence)", ", modids) + '|';
            return this;
        }

        protected AdvancedMixinInfoBuilder experimantal(String ... modids) {
            this.impacts = this.impacts + "Experimantal|";
            return this;
        }

        protected ImmutableSet<MixinInfo> build() {
            if (this.currentMixin != null) {
                this.infoList.add(new MixinInfo(this.currentMixin, this.usages, this.impacts));
            }
            return ImmutableSet.copyOf(this.infoList);
        }
    }
}

