/*
 * Decompiled with CFR 0.152.
 */
package lovexyn0827.mess;

import java.util.Collection;
import java.util.UUID;
import lovexyn0827.mess.MessComponent;
import lovexyn0827.mess.command.CommandUtil;
import lovexyn0827.mess.mixins.WorldSavePathMixin;
import lovexyn0827.mess.network.MessClientNetworkHandler;
import lovexyn0827.mess.network.MessServerNetworkHandler;
import lovexyn0827.mess.options.OptionManager;
import lovexyn0827.mess.rendering.ShapeCache;
import lovexyn0827.mess.rendering.ShapeRenderer;
import lovexyn0827.mess.rendering.ShapeSender;
import lovexyn0827.mess.util.LockableList;
import lovexyn0827.mess.util.access.CustomNode;
import lovexyn0827.mess.util.deobfuscating.Mapping;
import lovexyn0827.mess.util.deobfuscating.MappingProvider;
import lovexyn0827.mess.util.phase.ClientTickingPhase;
import lovexyn0827.mess.util.phase.ServerTickingPhase;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2598;
import net.minecraft.class_2661;
import net.minecraft.class_2678;
import net.minecraft.class_2724;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MessMod
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final MessMod INSTANCE = new MessMod();
    private static final LockableList<MessComponent> COMPONENTS = LockableList.create();
    private Mapping mapping;
    @Nullable
    private MinecraftServer server;
    private String scriptDir;
    @Environment(value=EnvType.CLIENT)
    public ShapeRenderer shapeRenderer;
    @Environment(value=EnvType.CLIENT)
    public ShapeCache shapeCache;
    public ShapeSender shapeSender;
    @Environment(value=EnvType.CLIENT)
    private MessClientNetworkHandler clientNetworkHandler;
    private MessServerNetworkHandler serverNetworkHandler;
    private long gameTime;

    private MessMod() {
    }

    public void reloadMapping() {
        this.mapping = new MappingProvider().tryLoadMapping();
    }

    public void onInitialize() {
        this.reloadMapping();
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public static boolean registerComponent(MessComponent comp) {
        if (!FabricLoader.getInstance().isModLoaded(comp.modid())) {
            LOGGER.error("MessComponent {} has incorrect modid", (Object)comp.modid());
            return false;
        }
        if (COMPONENTS.add(comp)) {
            return true;
        }
        LOGGER.warn("MessComponent {} has already been added.", (Object)comp.modid());
        return false;
    }

    public static Collection<MessComponent> getComponents() {
        if (COMPONENTS.isLocked()) {
            return COMPONENTS;
        }
        throw new IllegalStateException("Trying to get component list before initialization finishes!");
    }

    public static void lockComponentList() {
        COMPONENTS.lock();
    }

    public void onServerTicked(MinecraftServer server) {
        this.shapeSender.updateClientTime(server.method_30002().method_8510());
        MessMod.getComponents().forEach(c -> c.onServerTicked(server));
    }

    public void onServerStarted(MinecraftServer server) {
        this.server = server;
        CommandUtil.updateServer(server);
        OptionManager.updateServer(server);
        this.serverNetworkHandler = new MessServerNetworkHandler(server);
        CustomNode.reload(server);
        this.shapeSender = ShapeSender.create(server);
        MessMod.getComponents().forEach(c -> c.onServerStarted(server));
    }

    public void onServerShutdown(MinecraftServer server) {
        this.server = null;
        this.serverNetworkHandler = null;
        ServerTickingPhase.initialize();
        CommandUtil.updateServer(null);
        OptionManager.updateServer(null);
        MessMod.getComponents().forEach(c -> c.onServerShutdown(server));
    }

    public void onServerPlayerSpawned(class_3222 player) {
        if (MessMod.isDedicatedServerEnv()) {
            OptionManager.sendOptionsTo(player);
        }
        CommandUtil.tryUpdatePlayer(player);
        this.scriptDir = this.server.method_27050(WorldSavePathMixin.create("scripts")).toAbsolutePath().toString();
        MessMod.getComponents().forEach(c -> c.onServerPlayerSpawned(player));
    }

    @Environment(value=EnvType.CLIENT)
    public void onRender(class_746 player, class_1132 server) {
        MessMod.getComponents().forEach(c -> c.onGuiRendering());
    }

    @Environment(value=EnvType.CLIENT)
    public void onGameJoined(class_2678 packet) {
        ShapeRenderer sr;
        class_310 mc = class_310.method_1551();
        this.clientNetworkHandler = new MessClientNetworkHandler(mc);
        this.clientNetworkHandler.sendVersion();
        this.shapeRenderer = sr = new ShapeRenderer(mc);
        this.shapeCache = sr.getShapeCache();
        MessMod.getComponents().forEach(c -> c.onGameJoined());
    }

    @Environment(value=EnvType.CLIENT)
    public void onClientTickStart() {
        ClientTickingPhase.CLIENT_TICK_START.begin(null);
    }

    @Environment(value=EnvType.CLIENT)
    public void onClientTicked() {
        ClientTickingPhase.CLIENT_TICK_END.begin(null);
        MessMod.getComponents().forEach(c -> c.onClientTicked());
    }

    @Environment(value=EnvType.CLIENT)
    public void onDisconnected() {
        MessMod.getComponents().forEach(c -> c.onDisconnected());
    }

    @Environment(value=EnvType.CLIENT)
    public void onPlayerRespawned(class_2724 packet) {
        MessMod.getComponents().forEach(c -> c.onPlayerRespawned());
    }

    public void sendMessageToEveryone(Object ... message) {
        if (this.server == null) {
            throw new IllegalStateException("Called without a server started!");
        }
        StringBuilder sb = new StringBuilder();
        for (Object ob : message) {
            sb.append(ob);
        }
        this.server.method_3760().method_14616((class_2561)new class_2585(sb.toString()), class_2556.field_11735, new UUID(3273611L, 3272888L));
    }

    public String getScriptDir() {
        return this.scriptDir;
    }

    public static boolean isDedicatedEnv() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            return true;
        }
        class_310 mc = class_310.method_1551();
        return mc.method_1576() == null && mc.method_1558() != null && !mc.method_1558().method_2994();
    }

    @Environment(value=EnvType.CLIENT)
    public void onDisconnect(class_2661 packet) {
        this.shapeCache.reset();
        this.clientNetworkHandler = null;
    }

    public MessServerNetworkHandler getServerNetworkHandler() {
        return this.serverNetworkHandler;
    }

    @Environment(value=EnvType.CLIENT)
    public MessClientNetworkHandler getClientNetworkHandler() {
        return this.clientNetworkHandler;
    }

    public static boolean isDedicatedServerEnv() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public boolean isOnThread(class_2598 side) {
        if (side == class_2598.field_11942) {
            return class_310.method_1551().method_18854();
        }
        return this.server != null ? this.server.method_18854() : false;
    }

    public long getGameTime() {
        return this.gameTime;
    }

    public void updateTime(long time) {
        this.gameTime = time;
    }
}

