/*
 * Decompiled with CFR 0.152.
 */
package cn.royan.util.deobfuscator.map;

import cn.royan.MapStack;
import com.google.common.net.UrlEscapers;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class MappingProvider {
    private static final Logger LOGGER = MapStack.LOGGER;
    public static final String MINECRAFT_VERSION = "1.20.1";
    public static final String YARN_META = "https://meta.fabricmc.net/v2/versions/yarn/1.20.1";
    public static final String YARN_MAPPING = "https://maven.fabricmc.net/net/fabricmc/yarn/";
    public static final String STORAGE_DIRECTORY = "./config/mappings/";
    public static final String MAPPINGS_PATH = "mappings/mappings.tiny";

    public static String getYarnVersion() throws IOException {
        URL url = URI.create(YARN_META).toURL();
        URLConnection request = url.openConnection();
        String content = new String(request.getInputStream().readAllBytes(), StandardCharsets.UTF_8);
        Gson gson = new Gson();
        Type listType = new TypeToken<List<JsonObject>>(){}.getType();
        List list = (List)gson.fromJson(content, listType);
        return "1.20.1+build." + list.stream().mapToInt(obj -> obj.get("build").getAsInt()).max().orElse(-1);
    }

    public static synchronized FileInputStream getYarnMappingStream(String yarnVersion) throws IOException {
        File mappingFile = new File(STORAGE_DIRECTORY + MappingProvider.getMappingFileNameFull(yarnVersion));
        if (!mappingFile.exists() || !mappingFile.isFile()) {
            String mappingJar = String.format("%s.jar", MappingProvider.getMappingFileName(yarnVersion));
            String mappingJarUrl = String.format("%s%s/%s", YARN_MAPPING, yarnVersion, mappingJar);
            String escapedUrl = UrlEscapers.urlFragmentEscaper().escape(mappingJarUrl);
            LOGGER.info("Downloading mapping...");
            File jarFile = new File(STORAGE_DIRECTORY + mappingJar);
            FileUtils.copyURLToFile((URL)URI.create(escapedUrl).toURL(), (File)jarFile);
            try (FileSystem jar = FileSystems.newFileSystem(jarFile.toPath(), (ClassLoader)null);){
                Files.copy(jar.getPath(MAPPINGS_PATH, new String[0]), mappingFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            Files.delete(jarFile.toPath());
        }
        return new FileInputStream(mappingFile);
    }

    public static synchronized FileInputStream getCustomMappingStream(String name) throws IOException {
        File mappingFile = new File(STORAGE_DIRECTORY + name);
        return new FileInputStream(mappingFile);
    }

    private static String getMappingFileName(String yarnVersion) {
        return String.format("yarn-%s-v2", yarnVersion);
    }

    private static String getMappingFileNameFull(String yarnVersion) {
        return MappingProvider.getMappingFileName(yarnVersion) + ".tiny";
    }
}

