package cn.royan.util.deobfuscator;

import cn.royan.MapStack;
import cn.royan.util.deobfuscator.config.MappingSettings;
import cn.royan.util.deobfuscator.config.SettingsProvider;
import cn.royan.util.deobfuscator.map.MappingProvider;
import cn.royan.util.deobfuscator.map.TinyMappingV2Reader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.slf4j.Logger;

import java.io.*;
import java.util.List;
import java.util.Map;

public class StackTraceDeobfuscator {

    private static final Logger LOGGER = MapStack.LOGGER;
    public static String MAPPING_NAME = "empty";

    static Map<String, String> MAPPING = Maps.newHashMap();

    public static StackTraceElement[] deobfuscateStackTrace(StackTraceElement[] stackTraceElements)
    {
        List<StackTraceElement> list = Lists.newArrayList();
        for (StackTraceElement element : stackTraceElements)
        {
            String remappedClass = MAPPING.get(element.getClassName());
            String remappedMethod = MAPPING.get(element.getMethodName());
            StackTraceElement newElement = new StackTraceElement(
                    remappedClass != null ? remappedClass : element.getClassName(),
                    remappedMethod != null ? remappedMethod : element.getMethodName(),
                    remappedClass != null ? getFileName(remappedClass) : element.getFileName(),
                    element.getLineNumber()
            );
            list.add(newElement);
        }
        return list.toArray(new StackTraceElement[0]);
    }

    private static void getMapping()
    {
        try
        {
            SettingsProvider.loadSettings();

            MAPPING_NAME = MappingSettings.CustomMapping ? MappingSettings.CustomMapping_NAME : MappingProvider.getYarnVersion();

            FileInputStream mappingStream = MappingSettings.CustomMapping ? MappingProvider.getCustomMappingStream(MAPPING_NAME) : MappingProvider.getYarnMappingStream(MAPPING_NAME);
            BufferedReader reader = new BufferedReader(new InputStreamReader(mappingStream));

            TinyMappingV2Reader mappingReader = new TinyMappingV2Reader();
            MAPPING = mappingReader.readMapping(reader);

            LOGGER.info("Successfully loaded mapping | {}", MAPPING_NAME);
        }
        catch (IOException e)
        {
            LOGGER.error("Failed to load mapping: {}", e.toString());
        }
    }

    private static String getFileName(String className)
    {
        if (className.isEmpty())
        {
            return className;
        }
        return className.substring(className.lastIndexOf('.') + 1).split("\\$",2)[0] + ".java";
    }

    public static void loadMapping(){
        Thread thread = new Thread(StackTraceDeobfuscator::getMapping);
        thread.setName("Mapping thread");
        thread.start();
    }
}
