package cn.royan.mixin;

import cn.royan.util.deobfuscator.StackTraceDeobfuscator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import net.minecraft.class_128;

@Mixin(class_128.class)
public class CrashReportMixin {

    @Inject(method = "getCauseAsString", at = @At("RETURN"), cancellable = true, locals = LocalCapture.CAPTURE_FAILHARD)
    public void getCauseAsString(CallbackInfoReturnable<String> cir, StringWriter stringWriter, PrintWriter printWriter, Throwable throwable, String var4) {
        Throwable throwable1 = new Throwable();
        throwable1.setStackTrace(StackTraceDeobfuscator.deobfuscateStackTrace(throwable.getStackTrace()));
        String mappedStackTrace;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            ((Throwable)throwable1).printStackTrace(printWriter);
            mappedStackTrace = stringWriter.toString();
        } finally {
            IOUtils.closeQuietly((Writer)stringWriter);
            IOUtils.closeQuietly((Writer)printWriter);
        }
        cir.setReturnValue(mappedStackTrace);
    }

}
